/*
 * Decompiled with CFR 0.152.
 */
package dev.figboot.autool.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;

public class CountedOutputStream
extends OutputStream {
    private final OutputStream parent;
    private final Object countLock = new Object();
    private long count;
    private final Consumer<Long> postIncCallback;

    public CountedOutputStream(OutputStream parent, Consumer<Long> postIncCallback) {
        this.postIncCallback = postIncCallback;
        this.parent = parent;
        this.count = 0L;
    }

    public CountedOutputStream(OutputStream parent) {
        this(parent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incCount(long l) {
        long cpy;
        Object object = this.countLock;
        synchronized (object) {
            cpy = this.count;
            this.count += l;
        }
        if (this.postIncCallback != null) {
            this.postIncCallback.accept(cpy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        Object object = this.countLock;
        synchronized (object) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCount() {
        Object object = this.countLock;
        synchronized (object) {
            this.count = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCountAndReset() {
        Object object = this.countLock;
        synchronized (object) {
            long temp = this.count;
            this.count = 0L;
            return temp;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.parent.write(b);
        this.incCount(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.parent.write(b, off, len);
        this.incCount(len);
    }

    @Override
    public void flush() throws IOException {
        this.parent.flush();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.parent.write(b);
        this.incCount(1L);
    }
}

