/*
 * Decompiled with CFR 0.152.
 */
package dev.figboot.autool.patcher;

import dev.figboot.autool.config.PatchProperties;
import dev.figboot.autool.ui.ProgressUpdater;
import dev.figboot.autool.util.CountedInputStream;
import dev.figboot.autool.util.CountedOutputStream;
import dev.figboot.autool.util.DownloadUtil;
import dev.figboot.autool.util.Util;
import dev.figboot.autool.util.exception.CancelledException;
import io.sigpipe.jbsdiff.InvalidHeaderException;
import io.sigpipe.jbsdiff.Patch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.jar.JarFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.io.IOUtils;

public class ProgramPatcher {
    private final Proxy proxy;
    private final PatchProperties props;
    private final ProgressUpdater progress;
    private final File patcherDir;
    private final File origFile;
    private final File finalFile;

    public ProgramPatcher(PatchProperties props, Proxy proxy, File workDir, ProgressUpdater progress) {
        this.proxy = proxy;
        this.props = props;
        this.progress = progress;
        this.patcherDir = new File(workDir, "autool");
        this.origFile = new File(this.patcherDir, props.getOriginalName());
        this.finalFile = new File(this.patcherDir, props.getFinalName());
    }

    public void init() {
        try {
            Files.createDirectories(this.patcherDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Method getMainMethod() {
        this.ensureFinalFile();
        this.progress.changeStatus("Loading patched file...");
        try {
            JarFile jf = new JarFile(this.finalFile);
            String mainClass = this.props.getMainClass() != null ? this.props.getMainClass() : jf.getManifest().getMainAttributes().getValue("Main-Class");
            if (mainClass == null) {
                throw new RuntimeException("A main class could not be selected, please nag the developer.");
            }
            return new URLClassLoader(new URL[]{this.finalFile.toURI().toURL()}, null).loadClass(mainClass).getDeclaredMethod("main", String[].class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void ensureFinalFile() {
        if (!this.checkFinalFile()) {
            System.out.println("The final file is not present or has the wrong hash, repatching.");
            this.patch();
        }
    }

    private boolean checkFinalFile() {
        if (!this.finalFile.isFile()) {
            return false;
        }
        this.progress.changeStatus("Checking final file integrity...");
        this.progress.setMaxProgress((int)this.props.getFinalSize());
        return Util.checkFileIntegrity(this.finalFile, this.props.getFinalHash(), this.progress);
    }

    private void ensureOriginalFile() {
        if (!this.checkOrigFile()) {
            String hash;
            this.progress.changeStatus("Downloading original file...");
            this.progress.setMaxProgress((int)this.props.getOriginalSize());
            try (FileOutputStream os = new FileOutputStream(this.origFile);){
                hash = DownloadUtil.download(this.props.getOriginalURL(), this.proxy, this.progress, os);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error downloading original file", ex);
            }
            if (!hash.equalsIgnoreCase(this.props.getOriginalHash())) {
                this.progress.error("The downloaded original file does not match the expected hash!");
                throw new CancelledException();
            }
        }
    }

    private boolean checkOrigFile() {
        if (!this.origFile.isFile()) {
            return false;
        }
        this.progress.changeStatus("Checking original file integrity...");
        this.progress.setMaxProgress((int)this.props.getOriginalSize());
        return Util.checkFileIntegrity(this.origFile, this.props.getOriginalHash(), this.progress);
    }

    private void patch() {
        byte[] patchContents;
        byte[] origContents;
        CountedInputStream is;
        this.ensureOriginalFile();
        this.progress.changeStatus("Reading original file...");
        this.progress.setMaxProgress((int)this.props.getOriginalSize());
        try {
            is = new CountedInputStream(new FileInputStream(this.origFile), p -> this.progress.setProgress(p.intValue()));
            try {
                origContents = IOUtils.toByteArray(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading original file", ex);
        }
        this.progress.changeStatus("Reading patch...");
        this.progress.setMaxProgress((int)this.props.getPatchSize());
        try {
            is = new CountedInputStream(this.getClass().getResourceAsStream(this.props.getPatchResource()), p -> this.progress.setProgress(p.intValue()));
            try {
                patchContents = IOUtils.toByteArray(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading patch", ex);
        }
        this.progress.changeStatus("Patching original file...");
        this.progress.setMaxProgress((int)this.props.getFinalSize());
        try {
            MessageDigest digest = Util.createSHA1Digest();
            try (DigestOutputStream os = new DigestOutputStream(new FileOutputStream(this.finalFile), digest);){
                CountedOutputStream cos = new CountedOutputStream(os, p -> this.progress.setProgress(p.intValue()));
                Patch.patch(origContents, patchContents, cos);
                String hash = Util.digestToString(digest, 40);
                if (!hash.equalsIgnoreCase(this.props.getFinalHash())) {
                    this.progress.error("The patched final file does not match the expected hash!");
                    throw new CancelledException();
                }
            }
        }
        catch (IOException | CompressorException ex) {
            throw new RuntimeException("Error patching original file", ex);
        }
        catch (InvalidHeaderException ex) {
            throw new RuntimeException("The patch was in an invalid format?", ex);
        }
    }
}

