/*
 * Decompiled with CFR 0.152.
 */
package dev.figboot.autool.config;

import dev.figboot.autool.config.ConfigMethod;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;

public class PatchProperties {
    private static final String SYSTEM_PROPERTY_PREFIX = "sysprop.";
    private static final String CONFIG_RES = "/patch.properties";
    private final Properties properties;
    private URL originalURL;
    private String originalHash;
    private String originalName;
    private long originalSize;
    private String patchResource;
    private long patchSize;
    private String finalHash;
    private String finalName;
    private long finalSize;
    private boolean interactive;
    private String mainClass;
    private final Map<String, String> systemPropertiesMutable = new HashMap<String, String>();
    private final Map<String, String> systemProperties = Collections.unmodifiableMap(this.systemPropertiesMutable);

    public PatchProperties() throws IOException {
        this.properties = new Properties();
        this.properties.load(this.getClass().getResourceAsStream(CONFIG_RES));
        this.populate();
    }

    private void populate() {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String keyStr = entry.getKey().toString();
            if (keyStr.startsWith(SYSTEM_PROPERTY_PREFIX)) {
                this.systemPropertiesMutable.put(keyStr.substring(SYSTEM_PROPERTY_PREFIX.length()), entry.getValue().toString());
                continue;
            }
            try {
                Method method = this.getClass().getDeclaredMethod(keyStr, String.class);
                if (method.isAnnotationPresent(ConfigMethod.class)) {
                    method.invoke((Object)this, entry.getValue().toString());
                    continue;
                }
                System.err.println("Not calling method '" + method.getName() + "', as it is not annotated with @ConfigMethod.");
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Invalid patch properties", ex);
            }
            catch (ReflectiveOperationException ex) {
                System.err.println("Error while loading patch properties:");
                ex.printStackTrace();
            }
        }
    }

    @ConfigMethod
    private void origurl(String url) throws MalformedURLException {
        this.originalURL = new URL(url);
    }

    @ConfigMethod
    private void orighash(String hash) {
        this.originalHash = hash;
    }

    @ConfigMethod
    private void origname(String origname) {
        this.originalName = origname;
    }

    @ConfigMethod
    private void origsz(String origsz) {
        this.originalSize = Long.parseLong(origsz);
    }

    @ConfigMethod
    private void patchres(String patchres) {
        this.patchResource = patchres;
    }

    @ConfigMethod
    private void patchsz(String patchsz) {
        this.patchSize = Long.parseLong(patchsz);
    }

    @ConfigMethod
    private void finalhash(String finalhash) {
        this.finalHash = finalhash;
    }

    @ConfigMethod
    private void finalname(String finalname) {
        this.finalName = finalname;
    }

    @ConfigMethod
    private void finalsz(String finalsz) {
        this.finalSize = Long.parseLong(finalsz);
    }

    @ConfigMethod
    private void interactive(String interactive) {
        this.interactive = interactive.equalsIgnoreCase("true");
        String prop = System.getProperties().getProperty("dev.figboot.autool.AutoOL.interactive");
        if (prop != null) {
            this.interactive = prop.equalsIgnoreCase("true");
        }
    }

    @ConfigMethod
    private void mainclass(String mainclass) {
        this.mainClass = mainclass;
    }

    @Generated
    public URL getOriginalURL() {
        return this.originalURL;
    }

    @Generated
    public String getOriginalHash() {
        return this.originalHash;
    }

    @Generated
    public String getOriginalName() {
        return this.originalName;
    }

    @Generated
    public long getOriginalSize() {
        return this.originalSize;
    }

    @Generated
    public String getPatchResource() {
        return this.patchResource;
    }

    @Generated
    public long getPatchSize() {
        return this.patchSize;
    }

    @Generated
    public String getFinalHash() {
        return this.finalHash;
    }

    @Generated
    public String getFinalName() {
        return this.finalName;
    }

    @Generated
    public long getFinalSize() {
        return this.finalSize;
    }

    @Generated
    public boolean isInteractive() {
        return this.interactive;
    }

    @Generated
    public String getMainClass() {
        return this.mainClass;
    }

    @Generated
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }
}

